;
; copie este sujeito para um arquivo e monte com o pasmo:
; pasmo --msx noise.asm noise.bin
;
RDVRM:	    equ $004A
WRTVRM:	    equ $004D
T32NAM:     equ $F3BD
T32CGP:     equ $F3C1
JIFFY:      equ $FC9E

BLOCKS:     equ 16                  ; somente valores 2, 4, 8, 16 e 32

            org $c800

start_code:
            jp create_noise_blocks
            jp prepare_screen
            jp do_animation

rnd_seed:
			db 71						; valor inicial da semente


create_noise_blocks:
            ;
            ;   cria 'N' blocos de ruído, definido por BLOCKS.
            ;
            proc
            local __loop

            ld hl,(T32CGP)              ; início da tabela de padrões da SCR1
            ld b,BLOCKS*8               ; `B` = número de blocos × 8
      __loop:
            call random_number          ; sorteia um número
            call WRTVRM                 ; escreve na VRAM (apontado por `HL`)
            inc hl                      ; incrementa o ponteiro da VRAM
            djnz __loop                 ; `B`--, faz laço de `B` < 0

            ret                         ; sai da rotina
            endp


do_animation:
            proc
			local __loop

			ld b,BLOCKS*2   			; número de iterações

        __loop:
            call random_number			; sorteia um número
        
        if BLOCKS < 32
            and BLOCKS*8-1
        endif

            ld d,0
            ld e,a						; coloca em `DE` o valor sorteado
            ld hl,(T32CGP)              ; início da tabela de padrões da SCR1
            adc hl,de					; soma `HL` e `DE`

            call RDVRM                  ; lê o valor da VRAM

            xor $ff                     ; apenas inverte os bits 0 -> 1 e 1-> 0

            call WRTVRM                 ; escreve o valor na VRAM
			
            djnz __loop                 ; `B`--, faz laço de `B` < 0
            
            ret							; sai da rotina
            endp


prepare_screen:
            ;
            ;   coloca aleatoriamente blocos de ruído na tela.
            ;
            proc
            local __loop 

            ld hl,(T32NAM)              ; início da tabela de nomes da SCR1
 
            ld b,256                    ; `B` = 256 (na verdade é 0)
            call __loop                 ; preencho o primeiro terço
            call __loop                 ; preencho o segundo terço
 
        __loop:                         ; preencho o terceiro terço
            call random_number          ; sorteia um número
            and BLOCKS-1                ; somente os blocos de ruído
            call WRTVRM                 ; escreve o valor na VRAM
            inc hl                      ; incrementa endereço da VRAM
            djnz __loop                 ; `B`--, faz laço se `B` < 0

            ret                         ; retorna
            endp

random_number:
            ;
            ;   sorteia un número (pseudo) aleatório.
            ;
            proc
            ld a,(rnd_seed)
            ld c,a
        rept 3
            rrca
        endm
            xor $1f
            add a,c
            sbc a,253
            ld (rnd_seed),a

            ret
            endp