//*****************************************************************************
// Jogo da velha para MSX 
//
// Permite usar a placa Tic-tac-Toe desenvolvida para
// artigo na Clube MSX nr 
//
// Desenvolvido: Eng. Márcio José Soares
// Versão      : 1.0
// Data        : 23/12/2022
// 
// Compilador  : SDCC 4.0.0 (Linux)
// Testes      : OpenMSX 17.0 (Linux)
//               Hotbit Sharp (MSX1), Panasonic A1 (MSX2)
//               Panasonic A1-WSX (MSX2+)
//
//*****************************************************************************
// Copyright (c) 2022-2023 - Márcio José Soares / Revista Clube MSX
// All rights reserved.
//
// Redistribution and use of this source code or any derivative works, are
// permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Redistributions may not be sold, nor may they be used in a commercial
//    product or activity without specific prior written permission.
// 4. Source code of derivative works MUST be published to the public.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

//*****************************************************************************
// Arquivos incluídos no módulo
//*****************************************************************************
#include "../inc/my_defines.h"

//*****************************************************************************
// Função que retorna o status do jogo. 
//
// Entradas - nenhuma
// Saídas   - 1 se o game finalizou com result
//            -1 se o jogo está em progresso ou
//            0 jogo terminou sem vencedor
//*****************************************************************************
int verificaR(void){
	
    if (result[1] == result[2] && result[2] == result[3])
        return 1;
        
    else if (result[4] == result[5] && result[5] == result[6])
        return 1;
        
    else if (result[7] == result[8] && result[8] == result[9])
        return 1;
        
    else if (result[1] == result[4] && result[4] == result[7])
        return 1;
        
    else if (result[2] == result[5] && result[5] == result[8])
        return 1;
        
    else if (result[3] == result[6] && result[6] == result[9])
        return 1;
        
    else if (result[1] == result[5] && result[5] == result[9])
        return 1;
        
    else if (result[3] == result[5] && result[5] == result[7])
        return 1;
        
    else if (result[1] != '1' && result[2] != '2' && result[3] != '3' &&
        result[4] != '4' && result[5] != '5' && result[6] != '6' && result[7] 
        != '7' && result[8] != '8' && result[9] != '9')
			return 0;
    else
        return  - 1;
}

//*****************************************************************************
// Função para desenhar na tela o jogo
//
// Entradas - nenhuma
// Saídas   - nenhuma
//*****************************************************************************
void tabuleiro(void){
	
    Locate(0,5);
    printf("%s 1 (X)  -  %s 2 (O)", MSGs[language][3], MSGs[language][3]);

    Locate(0,7);
    printf("     |     |     \n\r");
    printf("  %c  |  %c  |  %c ", result[1], result[2], result[3]);

    Locate(0,9);
    printf("_____|_____|_____\n\r");
    printf("     |     |     ");

    Locate(0,11);
    printf("  %c  |  %c  |  %c \n\r", result[4], result[5], result[6]);

    printf("_____|_____|_____\n\r");
    printf("     |     |     ");

    Locate(0,14);
    printf("  %c  |  %c  |  %c \n\r", result[7], result[8], result[9]);
    printf("     |     |     \n\r\n\r");
}

//*****************************************************************************
// Função para limpar a placa do jogo - todos os LEDs desligados
//
// Entradas - nenhuma
// Saídas   - nenhumajogar novamente?P
//*****************************************************************************
void limpaLPT(void){
    
    OutPort(DLPT, 0x00);                                        // limpa portas
    OutPort(CLPT, 0x00);
}

//*****************************************************************************
// Função para desenhar na placa o jogo
//
// Entradas - nenhuma
// Saídas   - nenhuma
//*****************************************************************************
void tabLEDs(void){
    
    for(j = 0; j<3; j++){                                       // farre 3 linhas
        
        limpaLPT();
            
        tabcol = 0x00;                                          // limpa var para colunas
        tablin = LIN1;                                          // controla as linhas
            
        if(result[(j*3)+1] == 'X')                              // se jogador nr 1, sempre verde
            tabcol |= LEDG1;
        else if(result[(j*3)+1] == 'O')                         // do contrário, vermelho
            tabcol |= LEDR1;
    
    
        if(result[(j*3)+2] == 'X')                              // faz para as 3 colunas
            tabcol |= LEDG2;
        else if(result[(j*3)+2] == 'O')
            tabcol |= LEDR2;
        
    
        if(result[(j*3)+3] == 'X')
            tabcol |= LEDG3;
        else if(result[(j*3)+3] == 'O')
            tabcol |= LEDR3;
    
    
        if(j < 2)                                               // se esta nas linhas 1 e 2 faz OR do controle das linhas
            OutPort(DLPT, (tabcol | (tablin << (unsigned char)j)));
        else{
            OutPort(DLPT, tabcol);                              // mas se está na linha 3, 
            OutPort(CLPT, LIN3);                                // liga strobe
        }
        
        for(k=0;k<50;k++);                                      // apenas um delay!
    }
}

//*****************************************************************************
// Função para testar a placa o jogo
//
// Entradas - nenhuma
// Saídas   - nenhuma
//*****************************************************************************
void testLEDs(void){
    
    for(l=0;l<2;l++){                                           // varre leds verdes e vermelhos
        
        for(i=0;i<3;i++){                                       // varre 3 linhas
            tabcol = (0x01 << l);
            tablin = LIN1;                                      // controla as linhas
            for(j = 0; j<3; j++){                               // farre 3 colunas
            
                limpaLPT();
                       
                if(i < 2){                                      // se esta nas linhas 1 e 2 faz OR do controle das linhas
                    OutPort(DLPT, (tabcol | (tablin << (unsigned char)i)));
                }
                else{
                    OutPort(DLPT, tabcol);                      // mas se está na linha 3, 
                    OutPort(CLPT, LIN3);                        // liga strobe
                }
                tabcol <<= 0x02;
            
                for(k=0;k<5000;k++);
            }
        }
    }
}
    
//*****************************************************************************
// Função principal
//
// Entradas - nenhuma
// Saídas   - inteiro de retormo
//*****************************************************************************
int main(void){

    while(TRUE){
        Cls();
        printf("Chose your language:\n\r\n\r%s",MSG1);
        language = InputChar();
        if(language == '1' || language == '2')
            break;
    }
    
    language -= 0x31;
    
    while(TRUE){    
        Cls();
        Locate(0,1);
        printf("%s\n\r%s\n\r%s", MSGs[language][0], MSGs[language][1], MSGs[language][2]);
        
        if(!first){
            testLEDs();
            first = 1;
        }
    
        do{	
            tabuleiro();
            player = (player % 2) ? 1 : 2;
            Locate(0,17);
            printf("%s %d, %s:  ", MSGs[language][3], player, MSGs[language][4]);
            my_choice = 0;
            while(!my_choice){                                  // laço para leitura da tecla
                my_choice = Inkey();                            // pega tecla
                tabLEDs();
            }
            
            my_choice -= 0x30;
            selec = (player == 1) ? 'X' : 'O';

            if (my_choice == 1 && result[1] == '1')
                result[1] = selec;
            
            else if (my_choice == 2 && result[2] == '2')
                result[2] = selec;
            
            else if (my_choice == 3 && result[3] == '3')
                result[3] = selec;
            
            else if (my_choice == 4 && result[4] == '4')
                result[4] = selec;
            
            else if (my_choice == 5 && result[5] == '5')
                result[5] = selec;
            
            else if (my_choice == 6 && result[6] == '6')
                result[6] = selec;
            
            else if (my_choice == 7 && result[7] == '7')
                result[7] = selec;
            
            else if (my_choice == 8 && result[8] == '8')
                result[8] = selec;
            
            else if (my_choice == 9 && result[9] == '9')
                result[9] = selec;
            
            else{
                Locate(0,19);
                printf("%s", MSGs[language][5]);
                player--;
                my_choice = 0;
                while(!my_choice){
                    my_choice = Inkey();                        // pega tecla
                    tabLEDs();
                }
                Locate(0,19);                                   // limpa
                for(k=0;k<nrcols;k++)
                    printf(" ");
            }
        
            i = verificaR();

            player++;
        }while (i ==  - 1);
    
        tabuleiro();
        tabLEDs();
        
        Locate(0,17);
        for(k=0;k<nrcols;k++)
            printf(" ");
        
        Locate(0,19);
        for(k=0;k<nrcols;k++)
            printf(" ");
        
        Locate(0,17);                                           // posiciona para escrever
            
        if (i == 1){
            printf("==>%s %d %s ", MSGs[language][3], --player, MSGs[language][6]);
        }
        else{
            printf("==>%s",MSGs[language][7]);
        }
        
        printf("\n\r%s?",MSGs[language][8]);
        
        my_choice = 0;
        while(!my_choice){
            my_choice = Inkey();                                // pega tecla
            tabLEDs();                                          // mantem LEDs
            if(!language){                                      // se portugues selecionado
                if(my_choice == 'S' || my_choice == 's' || my_choice == 'N' || my_choice == 'n')
                    break;
                else
                    my_choice = 0;
            }
            else{
                if(my_choice == 'Y' || my_choice == 'y' || my_choice == 'N' || my_choice == 'n')
                    break;
                else
                    my_choice = 0;
            }
        }
        
        limpaLPT();
        
        if(my_choice == 'N' || my_choice == 'n'){               //se resposta negativa, sai do laço principal
            break;                          
        }
        else{                                                   //do contrário, limpa vars para novo jogo
            my_choice = 0;
            player = 1;
            tabcol = 0;
            tablin = 0;
            for(i=0;i<10;i++)
                result[i] = i+0x30;
        }
        
    }
    
    printf("\n\r");
    return 0;
}
