//*****************************************************************************
// my_defines.h - Definições importantes do módulo Jogo da Velha (main.c)
//
// by Eng. Márcio José Soares
//*****************************************************************************

//*****************************************************************************
// Arquivos incluídos no módulo
//*****************************************************************************
#include <stdio.h>
#include <string.h>
#include "../../fusion-c/header/io.h"
#include "../../fusion-c/header/msx_fusion.h"
#include "../../fusion-c/header/vdp_graph2.h"

//*****************************************************************************
// Definições de pré-configuração do módulo
//*****************************************************************************

//*****************************************************************************
// Definições importantes do módulo
//*****************************************************************************
#define  HALT 	__asm halt __endasm   	//aguarda pela próxima int

#define byte unsigned char
#define TRUE 0x01
#define FALSE 0x00

#define CR	0x0D
#define LF	0x0A

//*****************************************************************************
// Definições importantes para controle dos LEDs
//*****************************************************************************
#define CLPT 0x90				// endereço físico do controle na LPT MSX
#define DLPT 0x91				// endereço físico dos dados

#define LIN1 0x40				// bit D6 - liga a linha 1
#define LIN2 0x80				// bit D7 - liga a linha 2
#define LIN3 0x01				// bit Strobe - liga a linha 3

#define LEDG1 0x01				// bit D0 - LED 1 verde
#define LEDR1 0x02				// bit D1 - LED 1 vermelho
#define LEDG2 0x04				// bit D2 - LED 2 verde
#define LEDR2 0x08              // bit D3 - LED 2 vermelho
#define LEDG3 0x10				// bit D4 - LED 3 verde
#define LEDR3 0x20				// bit D5 - LED 3 vermelho

//*****************************************************************************
// Definições importantes para linguagens
//*****************************************************************************
#define MSG1	"1 - Portuguese\n\r2 - English"

//*****************************************************************************
// Constantes globais
//*****************************************************************************
const char *MSGs[2][9] = 
{
	{"Jogo da Velha","Revista Clube MSX","by Arne","Jogador","entre com um numero","Movimento invalido, tecle algo","venceu",
	 "Sem vencedor","Jogar novamente (S/N)"},
	{"Tic Tac Toe","Clube MSX Magazine","by Arne","Player","enter a number","Invalid move, type something","win","No winner","Play again (Y/N)"}
};


//*****************************************************************************
// Variáveis globais
//*****************************************************************************
char result[10] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
int player = 1;
int i, j, k, l;
int my_choice;
char selec;
unsigned char tabcol = 0;
unsigned char tablin = 0;
unsigned char language = 0;
unsigned char first = 0;
unsigned char nrcols = 40;

//*****************************************************************************
// Outros arquivos incluídos no módulo
//*****************************************************************************
