#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fusion-c/header/msx_fusion.h"
#include "fusion-c/header/psg.h"
#include "fusion-c/header/vdp_sprites.h"

#define MAX_INIMIGOS    10
#define NUM_CORES       11

enum estados{JOGA, QUIT, INICIO, JOGANDO, GAMEOVER};

typedef struct{
  int x, y, dx, dy;
  unsigned char sprite;
  unsigned char padrao;
  unsigned char cor;
  char ativo;
}Personagem;

static FCB file;

char texto[32];

static const char cores[NUM_CORES]={2, 4, 6, 8, 10, 12, 13, 3, 5, 9, 14};

static const unsigned char sprites[][8] = {
// Arco com a flecha
{ 0b00000001,
  0b00000011,
  0b00000110,
  0b00001100,
  0b00011000,
  0b00110000,
  0b01100000,
  0b11111111 },
{ 0b11111111,
  0b01100000,
  0b00110000,
  0b00011000,
  0b00001100,
  0b00000110,
  0b00000011,
  0b00000001 },
{ 0b10000000,
  0b01000000,
  0b00100000,
  0b00010000,
  0b00001000,
  0b00000100,
  0b00010110,
  0b11111111 },
{ 0b11111111,
  0b00010110,
  0b00000100,
  0b00001000,
  0b00010000,
  0b00100000,
  0b01000000,
  0b10000000 },
// Arco sem a flecha
{ 0b00000001,
  0b00000011,
  0b00000110,
  0b00001100,
  0b00011000,
  0b00110000,
  0b01100000,
  0b11000000 },
{ 0b11000000,
  0b01100000,
  0b00110000,
  0b00011000,
  0b00001100,
  0b00000110,
  0b00000011,
  0b00000001 },
{ 0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000 },
{ 0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000 },
// Flecha
{ 0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b01000000,
  0b11111111 },
{ 0b01000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000 },
{ 0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000101,
  0b11111111 },
{ 0b00000101,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000 },
// Balão
{ 0b00000111,
  0b00011111,
  0b00111111,
  0b01111111,
  0b01111111,
  0b11111111,
  0b11111111,
  0b11111111 },
{ 0b11111111,
  0b11111111,
  0b11111111,
  0b01111111,
  0b01111111,
  0b00111111,
  0b00011111,
  0b00000111 },
{ 0b11100000,
  0b11111000,
  0b11111100,
  0b11111110,
  0b11111110,
  0b11111111,
  0b11111111,
  0b11111111 },
{ 0b11111111,
  0b11111111,
  0b11111111,
  0b11111110,
  0b11111110,
  0b11111100,
  0b11111000,
  0b11100000 }
};

static unsigned char elevador[4][6][2]={
{ { 111,112},
  { 100,101},
  { 132,133},
  { 164,165},
  { 0,0},
  { 0,0} },
{ { 111,112},
  { 102,103},
  { 134,135},
  { 166,167},
  { 198,199},
  { 0,0} },
{ { 111,112},
  { 104,105},
  { 136,137},
  { 168,169},
  { 200,201},
  { 0,0} },
{ { 111,112},
  { 106,107},
  { 138,139},
  { 170,171},
  { 202,203},
  { 0,0} }
};

static unsigned char sol[2][2][2]={
{ { 96, 97},
  { 128, 129} },
{ { 98, 99},
  { 130, 131} }
};

static const unsigned char telaTitulo[768] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,1,1,6,0,5,1,1,6,0,1,0,0,0,5,1,1,6,0,5,1,1,6,0,1,1,1,6,0,0,
0,0,1,0,10,1,0,1,9,10,1,0,1,0,0,0,1,9,10,1,0,1,9,10,1,0,1,0,10,1,0,0,
0,0,1,0,12,1,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,1,0,0,
0,0,1,1,1,8,0,1,11,12,1,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,1,0,0,
0,0,1,0,10,6,0,1,1,1,1,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,1,0,0,
0,0,1,0,12,1,0,1,0,0,1,0,1,11,0,0,1,11,12,1,0,1,11,12,1,0,1,0,0,1,0,0,
0,0,1,1,1,8,0,1,0,0,1,0,1,1,1,0,7,1,1,8,0,7,1,1,8,0,1,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,1,6,0,5,1,1,6,0,1,1,1,6,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,10,1,0,1,9,10,1,0,1,0,10,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,12,1,0,1,0,0,1,0,1,0,12,1,0,0,0,12,1,11,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,1,8,0,1,0,0,1,0,1,1,1,8,0,1,1,1,1,1,1,1,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,10,1,9,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,1,11,12,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,7,1,1,8,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,80,82,69,83,83,0,83,80,65,67,69,0,84,79,0,83,84,65,82,84,0,0,0,0,0,0,
0,0,0,0,0,0,0,80,82,69,83,83,0,0,69,83,67,0,84,79,0,81,85,73,84,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,50,48,50,48,44,50,48,50,49,0,67,72,73,69,78,0,76,79,67,79,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

static const unsigned char telaJogo[768] = {
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,83,67,79,82,69,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,48,0,0,
1,1,1,96,97,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,128,129,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,76,73,70,69,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,51,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,111,112,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
13,14,15,16,13,14,15,16,13,14,15,16,13,14,15,16,13,14,15,16,13,14,0,0,0,0,0,0,0,0,0,0 };

unsigned char vram[14346];

char conta, leitura, linha, quadro;
int pontos, vidas;
int numBaloes, espera;
int difx, dify, estado;
FX somf, somb;

Personagem jogador, flecha;
Personagem baloes[MAX_INIMIGOS];

unsigned int end;

int titulo()
{
  end=Peekw(0xF3C7);
  CopyRamToVram(telaTitulo, end, 768);
  while(1){
    Halt();
    if(Inkey()==27)
      return QUIT;
    if(TriggerRead(0))
      return JOGA;
  }
}

void jogo()
{
  // Inicia o jogador
  jogador.x=176;
  jogador.y=88;
  jogador.dx=jogador.dy=0;
  jogador.sprite=0;
  jogador.padrao=0;
  jogador.cor=15;
  flecha.x=176;
  flecha.y=-32;
  flecha.ativo=0;
  flecha.sprite=1;
  flecha.padrao=8;
  flecha.cor=15;
  // Inicia os balões
  for(conta=0;conta<MAX_INIMIGOS;conta++){
    baloes[conta].ativo=baloes[conta].x=0;
    baloes[conta].y=-32;
    baloes[conta].dx=baloes[conta].dy=0;
    baloes[conta].cor=9;
    baloes[conta].padrao=12;
    baloes[conta].sprite=10+conta;
  }
  numBaloes=0;
  espera=0;
  pontos=0;
  vidas=3;
  estado=INICIO;
  end=Peekw(0xF3C7);
  CopyRamToVram(telaJogo, end, 768);
  // Imprime o placar
  sprintf(texto,"%d", pontos);
  CopyRamToVram(texto, end+94-strlen(texto), strlen(texto));
  sprintf(texto,"%d", vidas);
  CopyRamToVram(texto, end+254-strlen(texto), strlen(texto));

  // Loop principal
  while (estado!=QUIT) {
    if(Inkey()==27){
      estado=GAMEOVER;
      espera=0;
    }
    if(estado==JOGANDO)
    {
      if(numBaloes<pontos/5+1 && numBaloes<MAX_INIMIGOS && !espera){
        for(conta=0;conta<MAX_INIMIGOS;conta++)
          if(!baloes[conta].ativo){
            baloes[conta].y=191;
            baloes[conta].x=rand()%21*8;
            baloes[conta].dy=-1;
            numBaloes++;
            baloes[conta].ativo=1;
            baloes[conta].cor=cores[rand()%NUM_CORES];
            break;
          }
        espera=40;
      }
      if(espera)
        espera--;

      leitura=JoystickRead(0);
      switch(leitura) {
        case 1: // ↑
        case 2: // ↑ e →
        case 8: // ↑ e ←
          jogador.dy=-2; break;
        case 4: // ↓ e →
        case 5: // ↓
        case 6: // ↓ e ←
          jogador.dy=+2; break;
        default:
          jogador.dy = 0;
      }
      // Atirou uma flecha?
      if(TriggerRead(0) && !flecha.ativo){
        flecha.ativo=255;
        flecha.x=jogador.x;
        flecha.y=jogador.y;
        flecha.dx=-4;
        jogador.padrao=4;
        SoundFX(0,&somf);
      }
      // Atualiza o jogador
      jogador.y+=jogador.dy;
      if(jogador.y<8)
        jogador.y=8;
      else if(jogador.y>176)
        jogador.y=176;
      if(flecha.ativo)
        flecha.x+=flecha.dx;
      if(flecha.x<0){
        flecha.ativo=0;
        jogador.padrao=0;
        flecha.y=-32;
      }
      // Atualiza os balões
      for(conta=0;conta<MAX_INIMIGOS;conta++){
        if(baloes[conta].ativo){
          baloes[conta].y+=baloes[conta].dy;
          if(baloes[conta].y<-16  ){
            baloes[conta].ativo=0;
            baloes[conta].y=-32;
            PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
            numBaloes--;
            vidas--;
            sprintf(texto,"%d", vidas);
            CopyRamToVram(texto, end+254-strlen(texto), strlen(texto));
            if(vidas==0){
              estado=GAMEOVER;
              espera=0;
            }
          }
          else
          {
            if((difx=flecha.x-baloes[conta].x)<0)
              difx*=-1;
            if((dify=flecha.y-baloes[conta].y)<0)
              dify*=-1;
            if(difx<16 && dify<16){
              pontos++;
              numBaloes--;
              baloes[conta].ativo=0;
              baloes[conta].y=-32;
              PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
              sprintf(texto,"%d", pontos);
              CopyRamToVram(texto, end+94-strlen(texto), strlen(texto));
              SoundFX(0,&somb);
            }
          }
        }
      }
      // Desenha o sol normal ou assustado
      if((difx=24-flecha.x)<0)
        difx*=-1;
      if((dify=24-flecha.y)<0)
        dify*=-1;
        if(difx<16 && dify<16){
          CopyRamToVram(sol[1][0], end+99, 2);
          CopyRamToVram(sol[1][1], end+131, 2);
          espera=60;
        }
        else{
          if(espera>0)
            espera--;
          else{
            CopyRamToVram(sol[0][0], end+99, 2);
            CopyRamToVram(sol[0][1], end+131, 2);
          }
        }
    }
    else if(estado==INICIO){
      if(espera==0){
        CopyRamToVram("START", end+360, 5);
      }
      espera++;
      if(espera==180){
        estado=JOGANDO;
        CopyRamToVram(telaJogo, end+360, 5);
        espera=0;
      }
    }
    else if(estado==GAMEOVER){
      if(espera==0){
        CopyRamToVram("GAME OVER", end+358, 9);    
      }
      espera++;
      if(espera==180){
        estado=QUIT;
        espera=0;
        jogador.y=-32;
        flecha.y=-32;
        for(conta=0;conta<MAX_INIMIGOS;conta++)
          baloes[conta].y=-32;
      }
    }
    Halt();
    PutSprite(jogador.sprite, jogador.padrao, jogador.x, jogador.y, jogador.cor);
    PutSprite(flecha.sprite, flecha.padrao, flecha.x, flecha.y, flecha.cor);
    // O desenho começa duas linhas acima da linha do 
    linha=jogador.y/8-2;
    quadro=(jogador.y%8)/2;
    for(conta=0;conta<6;conta++)
      if(linha+conta>0 && linha+conta<24)
        CopyRamToVram(elevador[quadro][conta], end+(linha+conta)*32+22, 2);
    for(conta=0;conta<MAX_INIMIGOS;conta++)
      if(baloes[conta].ativo)
        PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
  }
  SilencePSG();
}

void FT_SetName( FCB *p_fcb, const char *p_name )
{
    char i, j;
    memset( p_fcb, 0, sizeof(FCB) );
    for( i = 0; i < 11; i++ ) {
        p_fcb->name[i] = ' ';
    }
    for( i = 0; (i < 8) && (p_name[i] != 0) && (p_name[i] != '.'); i++ ) {
        p_fcb->name[i] =  p_name[i];
    }
    if( p_name[i] == '.' ) {
        i++;
        for( j = 0; (j < 3) && (p_name[i + j] != 0) && (p_name[i + j] != '.'); j++ ) {
        p_fcb->ext[j] =  p_name[i + j] ;
        }
    }
}

void FT_errorHandler(char n, char *name)
{
    Screen(0);
    SetColors(15,6,6);
    switch (n)
    {
        case 1:
            Print("\n\rFAILED: fcb_open(): ");
            Print(name);
        break;

        case 2:
            Print("\n\rFAILED: fcb_close():");
            Print(name);
        break;

        case 3:
            Print("\n\rStop Kidding, run me on MSX2 !");
        break;
  }
Exit(0);
}

int FT_LoadData(char *file_name, char *buffer, int size, int skip)
{
    
    FT_SetName( &file, file_name );
    if(fcb_open( &file ) != FCB_SUCCESS) 
    {
          FT_errorHandler(1, file_name);
          return (0);
    }
    if (skip>0)
    {
        fcb_read( &file, buffer, skip );
    }
   
    
    fcb_read( &file, buffer, size );
    
    if( fcb_close( &file ) != FCB_SUCCESS ) 
    {
      FT_errorHandler(2, file_name);
      return (0);
    }
    return(0);
}


void main( void ) {
  int acao;
  TIME tm;
   
  if(ReadMSXtype()==3) {
    ChangeCPU(0);
  }
  GetTime(&tm);
  srand(tm.sec);
  Screen(1);
  SetColors(15,1,1);
  Print("Loading, please wait ...");
  FT_LoadData("balloon.sc2", vram, 14346, 7);
  // Apaga a tabela de carateres/nomes da imagem
  memset(&vram[6144], 0, 768);
  Screen(2);
  end=Peekw(0xF3CB);
  CopyRamToVram(vram, end, 14346);
  
  SetColors(15,1,1);
  for(conta=0;conta<16;conta++)
    SetSpritePattern(conta, sprites[conta], 8);
  for(conta=0;conta<32;conta++)
    PutSprite(conta, 0, 0, 192, 0);
  Sprite16();
  KeySound(0);
  // Efeito sonoro
  somf.isTone=true;
  somf.isNoise=false;
  somf.Tone=2048;
  somf.Noise=0;
  somf.Period=3200;
  somf.Shape=0;
  somb.isTone=false;
  somb.isNoise=true;
  somb.Tone=4096;
  somb.Noise=0;
  somb.Period=1600;
  somb.Shape=0;

  EnableInterupt();
  do
  {
    acao=titulo();
    if(acao!=QUIT)
      jogo();
  }while(acao!=QUIT);
  Screen(1);
  KeySound(1);
  Exit(0);
}
