#include <stdlib.h>
#include "fusion-c/header/msx_fusion.h"
#include "fusion-c/header/psg.h"
#include "fusion-c/header/vdp_sprites.h"

#define MAX_INIMIGOS    10
#define NUM_CORES       12

enum estados{JOGA, QUIT, INICIO, JOGANDO, GAMEOVER};

typedef struct{
  int x, y, dx, dy;
  unsigned char sprite;
  unsigned char padrao;
  unsigned char cor;
  char ativo;
}Personagem;

static const char cores[NUM_CORES]={2, 4, 6, 7, 8, 10, 12, 13, 3, 5, 9, 14};

static const unsigned char sprites[][8] = {
// Arco com a flecha
{ 0b00000001,
  0b00000011,
  0b00000110,
  0b00001100,
  0b00011000,
  0b00110000,
  0b01100000,
  0b11111111 },
{ 0b11111111,
  0b01100000,
  0b00110000,
  0b00011000,
  0b00001100,
  0b00000110,
  0b00000011,
  0b00000001 },
{ 0b10000000,
  0b01000000,
  0b00100000,
  0b00010000,
  0b00001000,
  0b00000100,
  0b00010110,
  0b11111111 },
{ 0b11111111,
  0b00010110,
  0b00000100,
  0b00001000,
  0b00010000,
  0b00100000,
  0b01000000,
  0b10000000 },
// Arco sem a flecha
{ 0b00000001,
  0b00000011,
  0b00000110,
  0b00001100,
  0b00011000,
  0b00110000,
  0b01100000,
  0b11000000 },
{ 0b11000000,
  0b01100000,
  0b00110000,
  0b00011000,
  0b00001100,
  0b00000110,
  0b00000011,
  0b00000001 },
{ 0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000 },
{ 0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000,
  0b10000000 },
// Flecha
{ 0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b01000000,
  0b11111111 },
{ 0b01000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000 },
{ 0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000101,
  0b11111111 },
{ 0b00000101,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000 },
// Balão
{ 0b00000111,
  0b00011111,
  0b00111111,
  0b01111111,
  0b01111111,
  0b11111111,
  0b11111111,
  0b11111111 },
{ 0b11111111,
  0b11111111,
  0b11111111,
  0b01111111,
  0b01111111,
  0b00111111,
  0b00011111,
  0b00000111 },
{ 0b11100000,
  0b11111000,
  0b11111100,
  0b11111110,
  0b11111110,
  0b11111111,
  0b11111111,
  0b11111111 },
{ 0b11111111,
  0b11111111,
  0b11111111,
  0b11111110,
  0b11111110,
  0b11111100,
  0b11111000,
  0b11100000 }
};

char conta, leitura;
int pontos, vidas;
int numBaloes, espera;
int difx, dify, estado;
FX somf, somb;

Personagem jogador, flecha;
Personagem baloes[MAX_INIMIGOS];

int titulo()
{
  Cls();
  Locate(8,7);
  Print("BALLOON POP");
  Locate(3,15);
  Print("Press SPACE to start!");
  Locate(5,17);
  Print("Press ESC to quit");
  Locate(6,21);
  Print("2020 Chien Loco");
  Locate(3,23);
  Print("Clube MSX Gold Disk#3");
  while(1){
    Halt();
    if(Inkey()==27)
      return QUIT;
    if(TriggerRead(0))
      return JOGA;
  }
}

void jogo()
{
  // Inicia o jogador
  jogador.x=176;
  jogador.y=88;
  jogador.dx=jogador.dy=0;
  jogador.sprite=0;
  jogador.padrao=0;
  jogador.cor=15;
  flecha.x=176;
  flecha.y=-32;
  flecha.ativo=0;
  flecha.sprite=1;
  flecha.padrao=8;
  flecha.cor=15;
  // Inicia os balões
  for(conta=0;conta<MAX_INIMIGOS;conta++){
    baloes[conta].ativo=baloes[conta].x=0;
    baloes[conta].y=-32;
    baloes[conta].dx=baloes[conta].dy=0;
    baloes[conta].cor=9;
    baloes[conta].padrao=12;
    baloes[conta].sprite=10+conta;
  }
  numBaloes=0;
  espera=0;
  pontos=0;
  vidas=3;
  estado=INICIO;

  Cls();
  // Imprime o placar
  Locate(20,0);
  Print("SCORE  ");
  Locate(26,0);
  PrintNumber(pontos);
  Locate(23,2);
  Print("LIFE x");
  Locate(29,2);
  PrintNumber(vidas);

  // Loop principal
  while (estado!=QUIT) {
    if(Inkey()==27){
      estado=GAMEOVER;
      espera=0;
    }
    if(estado==JOGANDO)
    {
      if(numBaloes<pontos/5+1 && numBaloes<MAX_INIMIGOS && !espera){
        for(conta=0;conta<MAX_INIMIGOS;conta++)
          if(!baloes[conta].ativo){
            baloes[conta].y=191;
            baloes[conta].x=rand()%21*8;
            baloes[conta].dy=-1;
            numBaloes++;
            baloes[conta].ativo=1;
            baloes[conta].cor=cores[rand()%NUM_CORES];
            break;
          }
        espera=40;
      }
      if(espera)
        espera--;

      leitura=JoystickRead(0);
      switch(leitura) {
        case 1: // ↑
        case 2: // ↑ e →
        case 8: // ↑ e ←
          jogador.dy=-2; break;
        case 4: // ↓ e →
        case 5: // ↓
        case 6: // ↓ e ←
          jogador.dy=+2; break;
        default:
          jogador.dy = 0;
      }
      // Atirou uma flecha?
      if(TriggerRead(0) && !flecha.ativo){
        flecha.ativo=255;
        flecha.x=jogador.x;
        flecha.y=jogador.y;
        flecha.dx=-4;
        jogador.padrao=4;
        SoundFX(0,&somf);
      }
      // Atualiza o jogador
      jogador.y+=jogador.dy;
      if(jogador.y<8)
        jogador.y=8;
      else if(jogador.y>176)
        jogador.y=176;
      if(flecha.ativo)
        flecha.x+=flecha.dx;
      if(flecha.x<0){
        flecha.ativo=0;
        jogador.padrao=0;
        flecha.y=-32;
      }
      // Atualiza os balões
      for(conta=0;conta<MAX_INIMIGOS;conta++){
        if(baloes[conta].ativo){
          baloes[conta].y+=baloes[conta].dy;
          if(baloes[conta].y<-16  ){
            baloes[conta].ativo=0;
            baloes[conta].y=-32;
            PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
            numBaloes--;
            vidas--;
            Locate(29,2);
            PrintNumber(vidas);
            if(vidas==0){
              estado=GAMEOVER;
              espera=0;
            }
          }
          else
          {
            if((difx=flecha.x-baloes[conta].x)<0)
              difx*=-1;
            if((dify=flecha.y-baloes[conta].y)<0)
              dify*=-1;
            if(difx<16 && dify<16){
              pontos++;
              numBaloes--;
              baloes[conta].ativo=0;
              baloes[conta].y=-32;
              PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
              Locate(26,0);
              PrintNumber(pontos);
              SoundFX(0,&somb);
            }
          }
        }
      }
    }
    else if(estado==INICIO){
      if(espera==0){
        Locate(8,11);
        Print("START");
      }
      espera++;
      if(espera==180){
        estado=JOGANDO;
        Locate(8,11);
        Print("     ");
        espera=0;
      }
    }
    else if(estado==GAMEOVER){
      if(espera==0){
        Locate(6,11);
        Print("GAME OVER");
      }
      espera++;
      if(espera==180){
        estado=QUIT;
        espera=0;
        jogador.y=-32;
        flecha.y=-32;
        for(conta=0;conta<MAX_INIMIGOS;conta++)
          baloes[conta].y=-32;
      }
    }
    Halt();
    PutSprite(jogador.sprite, jogador.padrao, jogador.x, jogador.y, jogador.cor);
    PutSprite(flecha.sprite, flecha.padrao, flecha.x, flecha.y, flecha.cor);
    for(conta=0;conta<MAX_INIMIGOS;conta++)
      if(baloes[conta].ativo)
        PutSprite(baloes[conta].sprite, baloes[conta].padrao, baloes[conta].x, baloes[conta].y, baloes[conta].cor);
  }
  SilencePSG();
}

void main( void ) {
  int acao;
  TIME tm;
    
  if(ReadMSXtype()==3) {
    ChangeCPU(0);
  }
  GetTime(&tm);
  srand(tm.sec);
  Screen(1);
  SetColors(15,1,1);
  for(conta=0;conta<16;conta++)
    SetSpritePattern(conta, sprites[conta], 8);
  Sprite16();
  KeySound(0);
  // Efeito sonoro
  somf.isTone=true;
  somf.isNoise=false;
  somf.Tone=2048;
  somf.Noise=0;
  somf.Period=3200;
  somf.Shape=0;
  somb.isTone=false;
  somb.isNoise=true;
  somb.Tone=4096;
  somb.Noise=0;
  somb.Period=1600;
  somb.Shape=0;

  EnableInterupt();
  do
  {
    acao=titulo();
    if(acao!=QUIT)
      jogo();
  }while(acao!=QUIT);
  Screen(1);
  KeySound(1);
  Exit(0);
}
